/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.kintai.action.AttendanceTotalAction;
import jp.mosp.kintai.dto.MSyukkinboDto;

import jp.mosp.payroll.dao.MKintaiDao;
import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dao.MKintaiKinmuDao;
import jp.mosp.payroll.dto.MKintaiDto;
import jp.mosp.payroll.dto.MKintaiKeisanDto;
import jp.mosp.payroll.dto.MKintaiKinmuDto;
import jp.mosp.payroll.vo.AttendanceCompileCardVo;

public class AttendanceCompileCardAction extends AttendanceTotalAction {

	// R}h
	private static final String CMD_COMPILE_CARD_SHOW   = "P1030";
	private static final String CMD_COMPILE_CARD_REGIST = "P1031";

	/**
	 * RXgN^
	 */
	public AttendanceCompileCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		AttendanceCompileCardVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof AttendanceCompileCardVo) {
			vo = (AttendanceCompileCardVo)obj;
			vo.clearMessage();
			vo.clearErrField();
		} else {
			vo = new AttendanceCompileCardVo();
		}		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// [U[擾
		getInfo(user.getUserId());
		// v_ẼZbg
		vo.aryPltSection = getSectionScopeArrayForPayroll();
		// ΑӌvZΏ۔N擾
		Date targetMonth = getCalcMonth();
		// R}h̏
		if (cmd.equals(CMD_COMPILE_CARD_SHOW)) {
			// \
			// ΑӌvZΏ۔NZbg
			vo.setHidCompileYear(String.valueOf(MospUtility.getYear(targetMonth)));
			vo.setHidCompileMonth(String.valueOf(MospUtility.getMonth(targetMonth)));
			// IR[hZbg
			vo.setPltSection(getBelongSectionCode(mKihon.getKCode()));
			// IԂ̃Zbg
			Date rangeMonth = util.getYearMonth(vo.getHidCompileYear(), vo.getHidCompileMonth());
			vo.setLblStartCompileDate(MospUtility.getDateString(getStartDate(rangeMonth), CommonConst.FORMAT_DATE));
			vo.setLblEndCompileDate(MospUtility.getDateString(getEndDate(rangeMonth), CommonConst.FORMAT_DATE));
			// [hݒ
			setMode(vo);
		} else if (cmd.equals(CMD_COMPILE_CARD_REGIST)) {
			// vZ
			runAttendanceCompile(vo, targetMonth);
			// R~bg
			commit();
			// ꗗ\
			setNextCmd(CompileAmendmentListAction.CMD_AMENDMENT_LIST_RE_SEARCH);
			// ꗗւ̏Zbg
			setNextCmdInfo(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ΑӌvZ
	 * @param vo			ΏVO
	 * @param targetMonth	Ώ۔N
	 * @throws Exception
	 */
	private void runAttendanceCompile(AttendanceCompileCardVo vo, Date targetMonth) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// ͍ڎ擾
		vo.setParams(request);
		// Wvf[^Ԑݒ
		setHours();
		// ΑӏWvpXg쐬
		List<MKintaiDto> listMKintai = new ArrayList<MKintaiDto>();
		// Ζ`ԕʏWvpXg쐬
		List<MKintaiKinmuDto> listMKinmu = new ArrayList<MKintaiKinmuDto>();
		if (vo.getPltSection().equals(CommonConst.NAM_COMMON_STRING_INITIAL_VALUE)) {
			// SБI
			// Sꗗ擾
			String[][] arySections = getSectionArrayAll();
			for (int i = 0; i < arySections.length; i++) {
				// ݐЎЈꗗ
				String[] aryAllusers = getBasisArray(arySections[i][0], targetMonth);
				for (int j = 0; j < aryAllusers.length; j++) {
					// ΑӃf[^擾
					getAttendanceList(aryAllusers[j], targetMonth);
					listMKintai.add(setCompileMonth(aryAllusers[j], targetMonth));
					listMKinmu.addAll(setWorkTypeList(aryAllusers[j], targetMonth));
				}
			}
			// ΑӏWv폜
			deleteTargetMonth(targetMonth);
			// ΑӏWvo^
			registMKintai(listMKintai, targetMonth);
			// Ζ`ԕʏWv폜
			deleteWorkType(targetMonth);
			// Ζ`ԕʏWvo^
			registMKinmu(listMKinmu, targetMonth);
		} else if (!vo.getTxtKCode().equals("")) {
			// ЈR[h͎
			// l̂݌vZ
			if (chkExistDto(getBasisInfo(vo.getTxtKCode()))) {
				// ΑӃf[^擾
				getAttendanceList(vo.getTxtKCode(), targetMonth);			
				listMKintai.add(setCompileMonth(vo.getTxtKCode(), targetMonth));
				listMKinmu.addAll(setWorkTypeList(vo.getTxtKCode(), targetMonth));
				// ΑӏWv폜
				deleteTargetMonth(vo.getTxtKCode(), targetMonth, vo);
				// ΑӏWvo^
				registMKintai(listMKintai, targetMonth);
				// Ζ`ԕʏWv폜
				deleteWorkType(vo.getTxtKCode(), targetMonth);
				// Ζ`ԕʏWvo^
				registMKinmu(listMKinmu, targetMonth);
			}
		} else {
			// ЈR[h
			// Î݌vZ
			// IЈR[hꗗ̎擾
			String[] aryUsers = getBasisArray(vo.getPltSection(), targetMonth);
			for (int i = 0; i < aryUsers.length; i++) {			
				// ΑӃf[^擾
				getAttendanceList(aryUsers[i], targetMonth);
				listMKintai.add(setCompileMonth(aryUsers[i], targetMonth));
				listMKinmu.addAll(setWorkTypeList(aryUsers[i], targetMonth));
			}
			// ΑӏWv폜Eo^
			registMKintaiForSection(listMKintai, targetMonth);
			// Ζ`ԕʏWv폜
			deleteWorkType(aryUsers, targetMonth);
			// Ζ`ԕʏWvo^
			registMKinmu(listMKinmu, targetMonth);
		}
	}

	/**
	 * Ζ`ԕʓo^
	 * @param kCode
	 * @param targetMonth
	 * @return	listMKinmu
	 * @throws Exception
	 */
	private List<MKintaiKinmuDto> setWorkTypeList(String kCode, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MKintaiKinmuDao dao = new MKintaiKinmuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<MKintaiKinmuDto> listMKinmu = new ArrayList<MKintaiKinmuDto>();
		// Ζ`ԕʏWvo^
		String[][] aryWorkType = getWorkTypeArrayAll();
		for (int k = 0; k < aryWorkType.length; k++) {
			// o^f[^̃Zbg
			listMKinmu.add(setCompileWorkType(kCode, targetMonth, aryWorkType[k][0]));
		}
		return listMKinmu;
	}

	/**
	 * Ζ`ԕʋΑӌWv
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @param WorkType		ΏۋΖ`ԃR[h
	 * @return	mKinmuDto	Wvς݋Ζ`ԕʏWvDTO
	 * @throws Exception
	 */
	private MKintaiKinmuDto setCompileWorkType(String kCode, Date targetMonth, String WorkType) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		MKintaiKinmuDto mKinmuDto = new MKintaiKinmuDto();
		// ϐ錾Aϐ̏
		// cƎԌv
		int totalOver = 0;
		// [鎞Ԍv
		int totalLateNight = 0;
		// xoԌv
		int totalHolidayWork = 0;
		// oΓv
		int totalWorkDays = 0;
		// 蓖
		int syokuji = 0;
		int cyoku1 = 0;
		int cyoku2 = 0;
		int cyoku3 = 0;
		int hoka1 = 0;
		int hoka2 = 0;
		int hoka3 = 0;
		int hoka4 = 0;
		int hoka5 = 0;
		// Wvf[^擾
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		// WvJn
		while (it.hasNext()) {
			MSyukkinboDto dto = it.next();
			// ΑӍ
			if (dto.getKinmu().equals(WorkType)) {
				// cƎ
				totalOver += dto.getZaJikan();
				// [鎞
				totalLateNight += dto.getSnJikan();
				// xo
				totalHolidayWork += dto.getKsJikan();
				// oΓ
				if (dto.getKinmuJi() > 0) {
					totalWorkDays++;
				}
				// 蓖
				syokuji += dto.getSyokuji();
				cyoku1 += dto.getCyoku1();
				cyoku2 += dto.getCyoku2();
				cyoku3 += dto.getCyoku3();
				hoka1 += dto.getHoka1();
				hoka2 += dto.getHoka2();
				hoka3 += dto.getHoka3();
				hoka4 += dto.getHoka4();
				hoka5 += dto.getHoka5();
			}
		}
		// DTOɒlZbg
		mKinmuDto.setKCode(kCode);
		// xN
		mKinmuDto.setSikyuYM(util.convDateToStringYearMonthShort(targetMonth));
		// Ζ`ԃR[h
		mKinmuDto.setKinmu(WorkType);
		// oΓ
		mKinmuDto.setSNissu(totalWorkDays);
		// cƎԍv
		mKinmuDto.setZaJikan(totalOver);
		// [鎞ԍv
		mKinmuDto.setSZJikan(totalLateNight);
		// xoԍv
		mKinmuDto.setHSJikan(totalHolidayWork);
		// 蓖
		// H蓖v
		mKinmuDto.setSyokuji(syokuji);
		// P蓖v
		mKinmuDto.setCyoku1(cyoku1);
		// Q蓖v
		mKinmuDto.setCyoku2(cyoku2);
		// R蓖v
		mKinmuDto.setCyoku3(cyoku3);
		// ̑蓖Pv
		mKinmuDto.setHoka1(hoka1);
		// ̑蓖Qv
		mKinmuDto.setHoka2(hoka2);
		// ̑蓖Rv
		mKinmuDto.setHoka3(hoka3);
		// ̑蓖Sv
		mKinmuDto.setHoka4(hoka4);
		// ̑蓖Tv
		mKinmuDto.setHoka5(hoka5);
		return mKinmuDto;
	}

	/**
	 *	o^O폜
	 * @param targetMonth	Ώ۔N
	 * @throws Exception
	 */
	private void deleteTargetMonth(Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		MKintaiDao dao = new MKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// e[ubN
		dao.tableLock(util.convDateToStringYearMonthShort(targetMonth));
		// f[^̍폜
		dao.delete(util.convDateToStringYearMonthShort(targetMonth));
		// ݃`FbN
		chkExistObject(dao.findForExport(util.convDateToStringYearMonthShort(targetMonth)));
	}

	/**
	 *	o^O폜
	 *  <p>2008/09/29	m.yoshida	lΉ</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	private void deleteTargetMonth(String kCode, Date targetMonth, AttendanceCompileCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		MKintaiDao dao = new MKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// e[ubN
		dao.tableLock(kCode, util.convDateToStringYearMonthShort(targetMonth));
		// f[^擾
		MKintaiDto currentDto = dao.findForKey(kCode, util.convDateToStringYearMonthShort(targetMonth));
		if (chkExistDto(currentDto)) {
			// 폜
			dao.delete(currentDto);
		}
		// ݃`FbN
		chkDuplicate(dao.findForKey(kCode, util.convDateToStringYearMonthShort(targetMonth)), vo);
	}

	/**
	 * 폜iΑӏWvj
	 * @param aryDto		ΏۋΑӏWvDTOz
	 * @param targetMonth	Ώ۔N
	 * @return	int			o^
	 * @throws Exception
	 */
	private int deleteMKintai(MKintaiDto[] aryDto, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MKintaiDao dao = new MKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ΑӏWv폜
		return dao.delete(aryDto, util.convDateToStringYearMonthShort(targetMonth));
	}

	/**
	 *	o^O폜
	 * @param targetMonth	Ώ۔N
	 * @return	boolean		ݗL
	 * @throws Exception
	 */
	private boolean deleteWorkType(Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MKintaiKinmuDao dao = new MKintaiKinmuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// e[ubN
		dao.tableLock(util.convDateToStringYearMonthShort(targetMonth));
		// 폜
		dao.delete(util.convDateToStringYearMonthShort(targetMonth));
		return chkExistObject(dao.findForCondition(util.convDateToStringYearMonthShort(targetMonth)));
	}

	/**
	 *	o^O폜
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @return	boolean		ݗL
	 * @throws Exception
	 */
	private boolean deleteWorkType(String kCode, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MKintaiKinmuDao dao = new MKintaiKinmuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// e[ubN
		dao.tableLock(kCode, util.convDateToStringYearMonthShort(targetMonth));
		// 폜
		dao.delete(kCode, util.convDateToStringYearMonthShort(targetMonth));
		// ݃`FbN
		return chkExistObject(dao.findForCondition(kCode, util.convDateToStringYearMonthShort(targetMonth)));
	}

	/**
	 *	o^O폜
	 * @param aryUsers		ЈR[hz
	 * @param targetMonth	Ώ۔N
	 * @throws Exception
	 */
	private void deleteWorkType(String[] aryUsers, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MKintaiKinmuDao dao = new MKintaiKinmuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// e[ubN
		dao.tableLock(aryUsers, util.convDateToStringYearMonthShort(targetMonth));
		// 
		int div = 100;
		// zdivƕB
		int i = 0;
		while ((aryUsers.length - (i * div)) >= div) {
			String[] aryKcode = new String[div];
			System.arraycopy(aryUsers, i * div, aryKcode, 0, div);
			// f[^̍폜
			dao.delete(aryKcode, util.convDateToStringYearMonthShort(targetMonth));
			i++;
		}
		if (aryUsers.length % div != 0) {
			String[] aryKcode = new String[aryUsers.length % div];
			System.arraycopy(aryUsers, i * div, aryKcode, 0, aryKcode.length);
			// f[^̍폜
			dao.delete(aryKcode, util.convDateToStringYearMonthShort(targetMonth));
		}
	}

	/**
	 * o^iΑӏWvj
	 * @param listMKintai	ΑӏWvDTOXg
	 * @param targetMonth	Ώ۔N
	 * @throws Exception
	 */
	private void registMKintai(List<MKintaiDto> listMKintai, Date targetMonth) throws Exception {
		// o^
		int insertCount = 0;
		// 񂷉
		int rev = 0;
		// 
		int div = 100;
		if (listMKintai.size() % div == 0) {
			rev = listMKintai.size() / div;
		} else {
			rev = listMKintai.size() / div + 1;
		}
		for (int i = 0; i < rev; i++) {
			List<MKintaiDto> currentList = new ArrayList<MKintaiDto>();
			// XgdivƕB
			for (int k = 0; k < div; k++) {
				int count = k + i * div;
				if (count >= listMKintai.size()) {
					break;
				}
				MKintaiDto mKintaiDto = listMKintai.get(count);
				if (chkExistDto(mKintaiDto)) {
					currentList.add(mKintaiDto);
				} else {
					break;
				}
			}
			// XgzɃZbgB
			MKintaiDto[] aryKintai = new MKintaiDto[currentList.size()];
			for (int j = 0; j < aryKintai.length; j++) {
				aryKintai[j] = currentList.get(j);
			}
			// o^			
			insertCount += registCompile(aryKintai, targetMonth);
		}
		if (insertCount != listMKintai.size()) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
	}

	/**
	 * o^iΑӏWvj
	 * @param listMKintai	ΑӏWvDTOXg
	 * @param targetMonth	Ώ۔N
	 * @throws Exception
	 */
	private void registMKintaiForSection(List<MKintaiDto> listMKintai, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MKintaiDao dao = new MKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// e[ubN
		dao.tableLock(listMKintai, util.convDateToStringYearMonthShort(targetMonth));
		// o^
		int insertCount = 0;
		// 񂷉
		int rev = 0;
		// 
		int div = 100;
		if (listMKintai.size() % div == 0) {
			rev = listMKintai.size() / div;
		} else {
			rev = listMKintai.size() / div + 1;
		}
		for (int i = 0; i < rev; i++) {
			List<MKintaiDto> currentList = new ArrayList<MKintaiDto>();
			// XgdivƕB
			for (int k = 0; k < div; k++) {
				int count = k + i * div;
				if (count >= listMKintai.size()) {
					break;
				}
				MKintaiDto mKintaiDto = listMKintai.get(count);
				if (chkExistDto(mKintaiDto)) {
					currentList.add(mKintaiDto);
				} else {
					break;
				}
			}
			// XgzɃZbgB
			MKintaiDto[] aryKintai = new MKintaiDto[currentList.size()];
			for (int j = 0; j < aryKintai.length; j++) {
				aryKintai[j] = currentList.get(j);
			}
			// 폜
			deleteMKintai(aryKintai, targetMonth);
			// o^
			insertCount += registCompile(aryKintai, targetMonth);
		}
		if (insertCount != listMKintai.size()) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
	}

	/**
	 * o^iΑӏWvj
	 * @param aryDto		ΏۋΑӏWvDTOz
	 * @param targetMonth	Ώ۔N
	 * @return	int			o^
	 * @throws Exception
	 */
	private int registCompile(MKintaiDto[] aryDto, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		MKintaiDao dao = new MKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ΑӏWvo^
		return dao.insert(aryDto);
	}

	/**
	 * o^iΖ`ԕʁj
	 * @param listMKinmu	Ζ`ԕʏWvDTOXg
	 * @param targetMonth	Ώ۔N
	 * @throws Exception
	 */
	private void registMKinmu(List<MKintaiKinmuDto> listMKinmu, Date targetMonth) throws Exception {
		// o^
		int insertCount = 0;
		// 񂷉
		int rev = 0;
		// 
		int div = 100;
		if (listMKinmu.size() % div == 0) {
			rev = listMKinmu.size() / div;
		} else {
			rev = listMKinmu.size() / div + 1;
		}
		for (int i = 0; i < rev; i++) {
			List<MKintaiKinmuDto> currentList = new ArrayList<MKintaiKinmuDto>();
			// XgdivƕB
			for (int k = 0; k < div; k++) {
				int count = k + i * div;
				if (count >= listMKinmu.size()) {
					break;
				}
				MKintaiKinmuDto mKinmuDto = listMKinmu.get(count);
				if (chkExistDto(mKinmuDto)) {
					currentList.add(mKinmuDto);
				} else {
					break;
				}
			}
			// XgzɃZbgB
			MKintaiKinmuDto[] aryKinmu = new MKintaiKinmuDto[currentList.size()];
			for (int j = 0; j < aryKinmu.length; j++) {
				aryKinmu[j] = currentList.get(j);
			}
			// zZbgB			
			insertCount += registWorkType(aryKinmu, targetMonth);
		}
		if (insertCount != listMKinmu.size()) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
	}

	/**
	 * o^iΖ`ԕʏWvj
	 * @param aryDto		ΏۋΖ`ԕʏWvDTO
	 * @param targetMonth	Ώ۔N
	 * @return	int			o^
	 * @throws Exception
	 */
	private int registWorkType(MKintaiKinmuDto[] aryDto, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MKintaiKinmuDao dao = new MKintaiKinmuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// Ζ`ԕʏWvo^
		return dao.insert(aryDto);
	}

	/**
	 * [hݒivZj
	 * @param vo
	 * @throws Exception
	 */
	private void setMode(AttendanceCompileCardVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MKintaiKeisanDao dao = new MKintaiKeisanDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		MKintaiKeisanDto dto = dao.findForCalc();
		if (chkExistDto(dto)) {
			if (dto.getKKanryou().equals(CommonConst.NUM_ATTENDANCE_CALCULATE_FLAG_ON)) {
				// [hݒ
				vo.setMode(AttendanceCompileCardVo.MODE_IMPOSSIBLE);
				// bZ[WpvZN
				String msgdate = dto.getKTNen() + CommonConst.STR_UNDER_SEPARATOR + dto.getKTTuki();
				// INvZ
				vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_CALCULATE, msgdate));
			} else {
				vo.setMode(AttendanceCompileCardVo.MODE_UPDATE);
			}
		} else {
			// [hݒ
			vo.setMode(AttendanceCompileCardVo.MODE_IMPOSSIBLE);
			// vZ񖳂
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * ꗗւ̏Zbg
	 * @param vo
	 * @throws Exception
	 */
	private void setNextCmdInfo(AttendanceCompileCardVo vo) throws Exception {
		// IR[h̃Zbg
		request.setAttribute(AttendanceCompileCardVo.COMPILE_SECTION, vo.getPltSection());
		// IЈR[h̃Zbg
		request.setAttribute(AttendanceCompileCardVo.COMPILE_K_CODE, vo.getTxtKCode());
		// bZ[Wݒ
		if (!vo.getTxtKCode().equals("") && !chkExistDto(getBasisInfo(vo.getTxtKCode()))) {
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_NO_CODE, ""));
		} else {
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		}
	}

}
